/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.flowable;

import dev.compactmods.crafting.lib.reactivestreams.Subscriber;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Flowable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.exceptions.Exceptions;
import dev.compactmods.crafting.lib.reactivex.rxjava3.functions.Supplier;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.fuseable.CancellableQueueFuseable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class FlowableFromRunnable<T>
extends Flowable<T>
implements Supplier<T> {
    final Runnable run;

    public FlowableFromRunnable(Runnable run) {
        this.run = run;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> subscriber) {
        CancellableQueueFuseable qs = new CancellableQueueFuseable();
        subscriber.onSubscribe(qs);
        if (!qs.isDisposed()) {
            try {
                this.run.run();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                if (!qs.isDisposed()) {
                    subscriber.onError(ex);
                } else {
                    RxJavaPlugins.onError(ex);
                }
                return;
            }
            if (!qs.isDisposed()) {
                subscriber.onComplete();
            }
        }
    }

    @Override
    public T get() throws Throwable {
        this.run.run();
        return null;
    }
}

